/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"Terms_Conditions_required":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629","all_notification_read":"\u062a\u0645 \u0642\u0631\u0627\u0621\u0629 \u062c\u0645\u064a\u0639 \u0627\u0644\u0625\u0634\u0639\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","amount":"\u0627\u0644\u0645\u0628\u0644\u063a","apply":"\u062a\u0637\u0628\u064a\u0642","appointment":"\u0645\u0648\u0639\u062f","appointment_date_required":"\u062d\u0642\u0644 \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u0648\u0639\u062f \u0645\u0637\u0644\u0648\u0628.","apr":"\u0625\u0628\u0631\u064a\u0644","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_cancel":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0644\u063a\u0627\u0621 \u0647\u0630\u0627","aug":"\u0623\u063a\u0633\u0637\u0633","booked":"\u0645\u062d\u062c\u0648\u0632","brand":"\u0639\u0644\u0627\u0645\u0629 \u062a\u062c\u0627\u0631\u064a\u0629","cancel":"\u0625\u0644\u063a\u0627\u0621","cancelled":"\u0645\u0644\u063a\u0627\u0629","cancelled_appointment":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f!","category":"\u0641\u0626\u0629","check_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","check_out":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062e\u0631\u0648\u062c","city":"\u0645\u062f\u064a\u0646\u0629","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0647\u0648","country":"\u0628\u0644\u062f","currency":"\u0639\u0645\u0644\u0629","custom":"\u0641\u062a\u0631\u0629 \u0645\u062e\u0635\u0635\u0629","day":"\u064a\u0648\u0645","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","degree_required":"\u062d\u0642\u0644 \u0627\u0644\u062f\u0631\u062c\u0629 \u0645\u0637\u0644\u0648\u0628.","delete":"\u062d\u0630\u0641","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","description_no_white_space":"\u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0642\u0635\u064a\u0631 \u0644\u0627 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0627\u062a \u0641\u0627\u0631\u063a\u0629 \u0641\u0642\u0637","discard":"\u062a\u062c\u0627\u0647\u0644","doctor":"\u0637\u0628\u064a\u0628","doctor_required":"\u062d\u0642\u0644 \u0627\u0644\u0637\u0628\u064a\u0628 \u0645\u0637\u0644\u0648\u0628.","doctor_session":"\u062c\u0644\u0633\u0629 \u0627\u0644\u0637\u0628\u064a\u0628","dose_interval":"\u062d\u062f\u062f \u0641\u0627\u0635\u0644 \u0627\u0644\u062c\u0631\u0639\u0629","email_already_exist":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0634\u062a\u0631\u0643 \u0628\u0627\u0644\u0641\u0639\u0644.","email_required":"\u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628.","enquiry":"\u0627\u0633\u062a\u0641\u0633\u0627\u0631","enter_lot_number":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u062f\u064f\u0641\u0639\u0629.","enter_sale_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639.","error":"\u062e\u0637\u0623","experience_required":"\u062d\u0642\u0644 \u0627\u0644\u062e\u0628\u0631\u0629 \u0645\u0637\u0644\u0648\u0628.","faqs":"\u0627\u0644\u0623\u0633\u0626\u0644\u0629 \u0627\u0644\u0634\u0627\u0626\u0639\u0629","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","first_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644 \u0645\u0637\u0644\u0648\u0628.","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","front_medical_services":"\u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0627\u0644\u0637\u0628\u064a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","front_patient_testimonials":"\u0634\u0647\u0627\u062f\u0627\u062a \u0627\u0644\u0645\u0631\u0636\u0649 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","has_been":"\u062a\u0645 \u062d\u0630\u0641.","has_cancel":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621.","image_file_type":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0646 \u0646\u0648\u0639: jpeg\u060c jpg\u060c png.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","last_30_days":"\u0627\u0644\u064030 \u064a\u0648\u0645\u064b\u0627 \u0627\u0644\u0623\u062e\u064a\u0631\u0629","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_name_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u062e\u064a\u0631 \u0645\u0637\u0644\u0648\u0628.","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","live_consultations":"\u0627\u0644\u0627\u0633\u062a\u0634\u0627\u0631\u0627\u062a \u0627\u0644\u0645\u0628\u0627\u0634\u0631\u0629","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","medicine":"\u0627\u0644\u062f\u0648\u0627\u0621","medicine_bill":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u062f\u0648\u0627\u0621","mon":"\u0627\u0644\u0627\u062b\u0646\u064a\u0646","month":"\u0634\u0647\u0631","net_amount_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0641\u0627\u0631\u063a\u064b\u0627.","net_amount_not_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0635\u0641\u0631\u064b\u0627.","no":"\u0644\u0627\u060c \u0625\u0644\u063a\u0627\u0621","note_white_space":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0644\u0627\u062d\u0638\u0629 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0627\u062a \u0641\u0627\u0631\u063a\u0629 \u0641\u0642\u0637.","notification_read":"\u062a\u0645 \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u0634\u0639\u0627\u0631 \u0628\u0646\u062c\u0627\u062d.","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","observation_white_space":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0631\u0627\u0642\u0628\u0629 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0627\u062a \u0641\u0627\u0631\u063a\u0629 \u0641\u0642\u0637.","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","ok":"\u062d\u0633\u0646\u0627\u064b","patient":"\u0645\u0631\u064a\u0636","patient_smart_card_deleted":"\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0630\u0643\u064a\u0629","payment_type_required":"\u062d\u0642\u0644 \u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0645\u0637\u0644\u0648\u0628.","please_select_patient":"\u064a\u0631\u062c\u0649 \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","please_wait":"\u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631...","prescription":"\u0648\u0635\u0641\u0629 \u0637\u0628\u064a\u0629","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","privacy_policy_required.":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","problem_white_space":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0634\u0643\u0644\u0629 \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0627\u062a \u0641\u0627\u0631\u063a\u0629 \u0641\u0642\u0637.","processing":"\u062c\u0627\u0631 \u0627\u0644\u0645\u0639\u0627\u0644\u062c\u0629...","purchase_medicine":"\u0634\u0631\u0627\u0621 \u0627\u0644\u062f\u0648\u0627\u0621","qualification":"\u0627\u0644\u062a\u0623\u0647\u064a\u0644","quantity_should":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 0.","roles":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631","sat":"\u0627\u0644\u0633\u0628\u062a","save":"\u062d\u0641\u0638","select_calendar.":"\u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u062a\u0642\u0648\u064a\u0645.","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_city":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u062f\u064a\u0646\u0629","select_doctor":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","select_duration":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u062f\u0629","select_medicine":"\u0627\u062e\u062a\u0631 \u062f\u0648\u0627\u0621","select_patient":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","select_payment":"\u064a\u0631\u062c\u0649 \u062a\u062d\u062f\u064a\u062f \u0623\u064a \u0637\u0631\u064a\u0642\u0629 \u062f\u0641\u0639 \u0648\u0627\u062d\u062f\u0629","select_service":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629","select_state":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0648\u0644\u0627\u064a\u0629","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","service":"\u0627\u0644\u062e\u062f\u0645\u0629","service_category":"\u0641\u0626\u0629 \u0627\u0644\u062e\u062f\u0645\u0629","service_required":"\u062d\u0642\u0644 \u0627\u0644\u062e\u062f\u0645\u0627\u062a \u0645\u0637\u0644\u0648\u0628.","specializations":"\u0627\u0644\u062a\u062e\u0635\u0635\u0627\u062a","staff":"\u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646","state":"\u0648\u0644\u0627\u064a\u0629","status_update":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","subscriber_creat":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0634\u062a\u0631\u0643 \u0628\u0646\u062c\u0627\u062d.","subscribers":"\u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0648\u0646","sun":"\u0627\u0644\u0623\u062d\u062f","tax_cannot_be_zero_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0628\u0644\u063a \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u064b\u0627.","tax_should_be":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0636\u0631\u0627\u0626\u0628 \u0623\u0642\u0644 \u0645\u0646 100\u066a.","terms_conditions":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","the_discount_shoul":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062a\u062e\u0641\u064a\u0636 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a","the_medicine_already_in_use":"\u0647\u0630\u0627 \u0627\u0644\u062f\u0648\u0627\u0621 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a \u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u062f\u0648\u0627\u0621\u060c \u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0631\u063a\u0628\u062a\u0643 \u0641\u064a \u062d\u0630\u0641\u0647\u061f","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0623\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","title_no_white_space":"\u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0648\u0635\u0641 \u0644\u0627 \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0627\u062a \u0641\u0627\u0631\u063a\u0629 \u0641\u0642\u0637","to":"\u0625\u0644\u0649","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","unavailable":"\u063a\u064a\u0631 \u0645\u062a\u0648\u0641\u0631","university_required":"\u0627\u0644\u062c\u0627\u0645\u0639\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","update_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646","valid_instagram":"\u064a\u0631\u062c\u0649 \u0625\u062f\u062e\u0627\u0644 \u0631\u0627\u0628\u0637 Instagram \u0635\u0627\u0644\u062d","valid_linkedin":"\u064a\u0631\u062c\u0649 \u0625\u062f\u062e\u0627\u0644 \u0631\u0627\u0628\u0637 Linkedin \u0635\u0627\u0644\u062d","valid_twitter":"\u064a\u0631\u062c\u0649 \u0625\u062f\u062e\u0627\u0644 \u0631\u0627\u0628\u0637 Twitter \u0635\u0627\u0644\u062d","visits":"\u0627\u0644\u0632\u064a\u0627\u0631\u0627\u062a","wed":"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621","year_required":"\u0627\u0644\u0633\u0646\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","yes":"\u0646\u0639\u0645\u060c \u062d\u0630\u0641!","yes_update":"\u0646\u0639\u0645\u060c \u062a\u062d\u062f\u064a\u062b!","yesterday":"\u0623\u0645\u0633"},"de.js":{"Terms_Conditions_required":"Gesch\u00e4ftsbedingungen sind erforderlich","all_notification_read":"Alle Benachrichtigungen erfolgreich gelesen.","amount":"Betrag","apply":"Anwenden","appointment":"Termin","appointment_date_required":"Termin Datum ist erforderlich.","apr":"Apr","are_you_sure":"Sind Sie sicher, dass Sie dies l\u00f6schen m\u00f6chten","are_you_sure_cancel":"Sind Sie sicher, dass Sie dies stornieren m\u00f6chten","aug":"Aug","booked":"Gebucht","brand":"Marke","cancel":"Abbrechen","cancelled":"Abgesagt","cancelled_appointment":"Abgesagter Termin!","category":"Kategorie","check_in":"Einchecken","check_out":"Auschecken","city":"Stadt","contact_number":"Kontakt Nummer ist","country":"Land","currency":"W\u00e4hrung","custom":"Benutzerdefinierter Bereich","day":"Tag","dec":"Dez","degree_required":"Das Feld Abschluss ist erforderlich.","delete":"L\u00f6schen","deleted":"Gel\u00f6scht!","description_no_white_space":"Die Kurzbeschreibung darf keine Leerzeichen enthalten","discard":"Verwerfen","doctor":"Arzt","doctor_required":"Arzt ist erforderlich.","doctor_session":"Arztsprechstunde","dose_interval":"Dosisintervall ausw\u00e4hlen","email_already_exist":"Die E-Mail existiert bereits im Abonnement.","email_required":"Die E-Mail-Adresse ist erforderlich.","enquiry":"Anfrage","enter_lot_number":"Lot-Nummer eingeben.","enter_sale_price":"Verkaufspreis eingeben.","error":"Fehler","experience_required":"Erfahrung ist erforderlich.","faqs":"FAQs","feb":"Feb","first_name_required":"Der Vorname ist erforderlich.","fri":"FR","from":"Von","front_medical_services":"Frontmedizinische Dienstleistungen","front_patient_testimonials":"Front Patientenbewertungen","has_been":"wurde gel\u00f6scht.","has_cancel":" wurde abgesagt.","image_file_type":"Das Bild muss ein Dateityp sein: jpeg, jpg, png.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"Letzte 30 Tage","last_month":"Letzter Monat","last_name_required":"Der Nachname ist erforderlich.","last_week":"Letzte Woche","live_consultations":"Live-Beratungen","mar":"M\u00e4r","may":"Mai","medicine":"Medizin","medicine_bill":"Medikamentenrechnung","mon":"MO","month":"Monat","net_amount_not_empty":"Der Netto-Betrag darf nicht leer sein.","net_amount_not_zero":"Der Netto-Betrag darf nicht null sein.","no":"Nein, Abbrechen","note_white_space":"Das Notizfeld darf keine Leerzeichen enthalten.","notification_read":"Benachrichtigung erfolgreich gelesen.","nov":"Nov","observation_white_space":"Das Beobachtungsfeld darf keine Leerzeichen enthalten.","oct":"Okt","ok":"OK","patient":"Patient","patient_smart_card_deleted":"Patienten-Smartcard","payment_type_required":"Zahlungsmethode ist erforderlich.","please_select_patient":"Bitte Patienten ausw\u00e4hlen","please_wait":"Bitte warten...","prescription":"Rezept","privacy_policy":"Datenschutzbestimmungen","privacy_policy_required.":"Die Datenschutzbestimmungen sind erforderlich.","problem_white_space":"Das Problem-Feld darf keine Leerzeichen enthalten.","processing":"Verarbeitung..","purchase_medicine":"Medizin kaufen","qualification":"Qualifikation","quantity_should":"Die Menge sollte gr\u00f6\u00dfer als 0 sein.","roles":"Rollen","sat":"SA","save":"Speichern","select_calendar.":"Bitte w\u00e4hlen Sie einen Kalender aus.","select_category":"Kategorie ausw\u00e4hlen","select_city":"Stadt ausw\u00e4hlen","select_doctor":"Arzt ausw\u00e4hlen","select_duration":"Dauer ausw\u00e4hlen","select_medicine":"Medizin ausw\u00e4hlen","select_patient":"Patient ausw\u00e4hlen","select_payment":"Bitte w\u00e4hlen Sie eine Zahlungsmethode","select_service":"Dienst ausw\u00e4hlen","select_state":"Bundesland ausw\u00e4hlen","sep":"Sep","service":"Dienstleistung","service_category":"Dienstleistungskategorie","service_required":"Dienst ist erforderlich.","specializations":"Fachgebiete","staff":"Personal","state":"Bundesland","status_update":"Status erfolgreich aktualisiert.","subscriber_creat":"Abonnent erfolgreich erstellt.","subscribers":"Abonnenten","sun":"SO","tax_cannot_be_zero_empty":"Der Steuerbetrag darf nicht null oder leer sein.","tax_should_be":"Steuern sollten weniger als 100% sein.","terms_conditions":"Gesch\u00e4ftsbedingungen","the_discount_shoul":"Der Rabatt sollte weniger als der Gesamtbetrag sein","the_medicine_already_in_use":"Dieses Medikament wird bereits in Rechnungen verwendet. M\u00f6chten Sie es wirklich l\u00f6schen?","this_month":"Dieser Monat","this_week":"Diese Woche","thu":"DO","title_no_white_space":"Der Titel darf keine Leerzeichen enthalten","to":"Bis","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"DI","unavailable":"Nicht verf\u00fcgbar","university_required":"Die Universit\u00e4t ist erforderlich.","update_quantity":"Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.","valid_instagram":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","valid_linkedin":"Bitte geben Sie eine g\u00fcltige LinkedIn-URL ein","valid_twitter":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","visits":"Besuche","wed":"MI","year_required":"Das Jahr ist erforderlich.","yes":"Ja, L\u00f6schen!","yes_update":"Ja, Aktualisieren!","yesterday":"Gestern"},"en.js":{"Terms_Conditions_required":"Terms & Conditions is required","all_notification_read":"All Notification read successfully.","amount":"Amount","apply":"Apply","appointment":"Appointment","appointment_date_required":"Appointment date field is required.","apr":"Apr","are_you_sure":"Are you sure want to delete this","are_you_sure_cancel":"Are you sure want to cancel this ","aug":"Aug","booked":"Booked","brand":"Brand","cancel":"Cancel","cancelled":"Cancelled","cancelled_appointment":"Cancelled Appointment !","category":"Category","check_in":"Check In","check_out":"Check Out","city":"City","contact_number":"Contact number is","country":"Country","currency":"Currency","custom":"Custom Range","day":"Day","dec":"Dec","degree_required":"The degree field is required.","delete":"Delete","deleted":"Deleted!","description_no_white_space":"About Short Description field is not contain only white space","discard":"Discard","doctor":"Doctor","doctor_required":"Doctor field is required.","doctor_session":"Doctor Schedule","dose_interval":"Select Dose Interval","email_already_exist":"The email has already subscribe.","email_required":"Email field is required.","enquiry":"Enquiry","enter_lot_number":"Enter lot number.","enter_sale_price":"Enter sale price.","error":"Error","experience_required":"About Experience field is required.","faqs":"FAQs","feb":"Feb","first_name_required":"First name field is required. ","fri":"FRI","from":"From","front_medical_services":"Front Medical Services","front_patient_testimonials":"Front Patient Testimonials","has_been":"has been deleted.","has_cancel":" has been Cancelled.","image_file_type":"The image must be a file of type: jpeg, jpg, png.","invalid_country_code":"Invalid country code","invalid_number":"Invalid Number","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"Last 30 Days","last_month":"Last Month","last_name_required":"Last name field is required.","last_week":"Last Week","live_consultations":"Live Consultations","mar":"Mar","may":"May","medicine":"Medicine","medicine_bill":"Medicine Bill","mon":"MON","month":"Month","net_amount_not_empty":"Net amount can not be empty.","net_amount_not_zero":"Net amount can not be zero.","no":"No, Cancel","note_white_space":"Note field is not contain only white space.","notification_read":"Notification read successfully.","nov":"Nov","observation_white_space":"Observation field is not contain only white space.","oct":"Oct","ok":"Ok","patient":"Patient","patient_smart_card_deleted":"Patient Smart Card","payment_type_required":"Payment Method field is required.","please_select_patient":"Please Select Patient","please_wait":"Please wait...","prescription":"Prescription","privacy_policy":"Privacy Policy","privacy_policy_required.":"The Privacy Policy is required.","problem_white_space":"Problem field is not contain only white space.","processing":"Processing..","purchase_medicine":"Purchase Medicine","qualification":"Qualification","quantity_should":"Quantity should be greater than 0.","roles":"Roles","sat":"SAT","save":"Save","select_calendar.":"Please select a calendar.","select_category":"Select Category","select_city":"Select City","select_doctor":"Select Doctor","select_duration":"Select Duration","select_medicine":"Select Medicine","select_patient":"Select Patient","select_payment":"Please select any one Payment Method","select_service":"Select Service","select_state":"Select State","sep":"Sep","service":"Service","service_category":"Service Category","service_required":"Services field is required.","specializations":"Specializations","staff":"Staff","state":"State","status_update":"Status updated successfully.","subscriber_creat":"Subscriber created successfully.","subscribers":"Subscribers","sun":"SUN","tax_cannot_be_zero_empty":"The tax amount can not be zero or empty.","tax_should_be":"Taxes should be less than 100%.","terms_conditions":"Terms & Conditions","the_discount_shoul":"The discount should be less than the total amount","the_medicine_already_in_use":"This medicine is already used in medicine bills, are you sure want to delete it?","this_month":"This Month","this_week":"This Week","thu":"THU","title_no_white_space":"About Title field is not contain only white space","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","unavailable":"Unavailable","university_required":"The university is required.","update_quantity":"Update quantity should be less than previous quantity.","valid_instagram":"Please enter a valid Instagram Url","valid_linkedin":"Please enter a valid Linkedin Url","valid_twitter":"Please enter a valid Twitter Url","visits":"Visits","wed":"WED","year_required":"The year is required.","yes":"Yes, Delete!","yes_update":"Yes, Update!","yesterday":"Yesterday"},"es.js":{"Terms_Conditions_required":"Se requieren los T\u00e9rminos y Condiciones","all_notification_read":"Todas las notificaciones le\u00eddas exitosamente.","amount":"Monto","apply":"Aplicar","appointment":"Cita","appointment_date_required":"El campo de fecha de cita es obligatorio.","apr":"Abr","are_you_sure":"\u00bfEst\u00e1s seguro de querer eliminar esto?","are_you_sure_cancel":"\u00bfEst\u00e1s seguro de querer cancelar esto?","aug":"Ago","booked":"Reservado","brand":"Marca","cancel":"Cancelar","cancelled":"Cancelado","cancelled_appointment":"\u00a1Cita Cancelada!","category":"Categor\u00eda","check_in":"Registrarse","check_out":"Salir","city":"Ciudad","contact_number":"El n\u00famero de contacto es","country":"Pa\u00eds","currency":"Moneda","custom":"Rango personalizado","day":"D\u00eda","dec":"Dic","degree_required":"El campo de grado es obligatorio.","delete":"Eliminar","deleted":"\u00a1Eliminado!","description_no_white_space":"El campo de Descripci\u00f3n Corta no debe contener solo espacios en blanco","discard":"Descartar","doctor":"Doctor","doctor_required":"El campo de doctor es obligatorio.","doctor_session":"Horario del Doctor","dose_interval":"Seleccionar Intervalo de Dosis","email_already_exist":"El correo electr\u00f3nico ya est\u00e1 suscrito.","email_required":"El campo de correo electr\u00f3nico es obligatorio.","enquiry":"Consulta","enter_lot_number":"Ingrese el n\u00famero de lote.","enter_sale_price":"Ingrese el precio de venta.","error":"Error","experience_required":"El campo de Experiencia es obligatorio.","faqs":"Preguntas Frecuentes","feb":"Feb","first_name_required":"El campo de nombre es obligatorio.","fri":"VIE","from":"Desde","front_medical_services":"Servicios M\u00e9dicos Frontales","front_patient_testimonials":"Testimonios de Pacientes Frontales","has_been":"ha sido eliminado.","has_cancel":" ha sido Cancelado.","image_file_type":"La imagen debe ser un archivo de tipo: jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","jan":"Ene","jul":"Jul","jun":"Jun","last_30_days":"\u00daltimos 30 d\u00edas","last_month":"El mes pasado","last_name_required":"El campo de apellido es obligatorio.","last_week":"La semana pasada","live_consultations":"Consultas en Vivo","mar":"Mar","may":"Mayo","medicine":"Medicamento","medicine_bill":"Factura de medicamentos","mon":"LUN","month":"Mes","net_amount_not_empty":"El monto neto no puede estar vac\u00edo.","net_amount_not_zero":"El monto neto no puede ser cero.","no":"No, Cancelar","note_white_space":"El campo de nota no debe contener solo espacios en blanco.","notification_read":"Notificaci\u00f3n le\u00edda exitosamente.","nov":"Nov","observation_white_space":"El campo de observaci\u00f3n no debe contener solo espacios en blanco.","oct":"Oct","ok":"Aceptar","patient":"Paciente","patient_smart_card_deleted":"Tarjeta inteligente del paciente","payment_type_required":"El campo de M\u00e9todo de Pago es obligatorio.","please_select_patient":"Por favor, seleccione paciente","please_wait":"Por favor, espera...","prescription":"Receta","privacy_policy":"Pol\u00edtica de Privacidad","privacy_policy_required.":"La Pol\u00edtica de Privacidad es obligatoria.","problem_white_space":"El campo de problema no debe contener solo espacios en blanco.","processing":"Procesando...","purchase_medicine":"Comprar medicamentos","qualification":"Calificaci\u00f3n","quantity_should":"La cantidad debe ser mayor que 0.","roles":"Roles","sat":"S\u00c1B","save":"Guardar","select_calendar.":"Por favor, selecciona un calendario.","select_category":"Seleccionar Categor\u00eda","select_city":"Seleccionar Ciudad","select_doctor":"Seleccionar Doctor","select_duration":"Seleccionar Duraci\u00f3n","select_medicine":"Seleccionar Medicamento","select_patient":"Seleccionar paciente","select_payment":"Por favor, selecciona un M\u00e9todo de Pago","select_service":"Seleccionar Servicio","select_state":"Seleccionar Estado","sep":"Sep","service":"Servicio","service_category":"Categor\u00eda de servicio","service_required":"El campo de servicios es obligatorio.","specializations":"Especializaciones","staff":"Personal","state":"Estado","status_update":"Estado actualizado correctamente.","subscriber_creat":"Suscriptor creado exitosamente.","subscribers":"Suscriptores","sun":"DOM","tax_cannot_be_zero_empty":"El monto del impuesto no puede ser cero o estar vac\u00edo.","tax_should_be":"Los impuestos deben ser inferiores al 100%.","terms_conditions":"T\u00e9rminos y Condiciones","the_discount_shoul":"El descuento debe ser menor que el monto total","the_medicine_already_in_use":"Este medicamento ya se utiliza en facturas de medicamentos, \u00bfest\u00e1 seguro de que desea eliminarlo?","this_month":"Este mes","this_week":"Esta semana","thu":"JUE","title_no_white_space":"El campo de T\u00edtulo no debe contener solo espacios en blanco","to":"Hasta","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corto","tue":"MAR","unavailable":"No disponible","university_required":"La universidad es obligatoria.","update_quantity":"La cantidad de actualizaci\u00f3n debe ser menor que la cantidad anterior.","valid_instagram":"Por favor, introduce una URL de Instagram v\u00e1lida","valid_linkedin":"Por favor, introduce una URL de Linkedin v\u00e1lida","valid_twitter":"Por favor, introduce una URL de Twitter v\u00e1lida","visits":"Visitas","wed":"MI\u00c9","year_required":"El a\u00f1o es obligatorio.","yes":"S\u00ed, \u00a1Eliminar!","yes_update":"\u00a1S\u00ed, Actualizar!","yesterday":"Ayer"},"fr.js":{"Terms_Conditions_required":"Les conditions g\u00e9n\u00e9rales sont obligatoires","all_notification_read":"Toutes les notifications lues avec succ\u00e8s.","amount":"Montant","apply":"Appliquer","appointment":"Rendez-vous","appointment_date_required":"Le champ de la date du rendez-vous est obligatoire.","apr":"Avr","are_you_sure":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_cancel":"\u00cates-vous s\u00fbr de vouloir annuler ceci ","aug":"Ao\u00fbt","booked":"R\u00e9serv\u00e9","brand":"Marque","cancel":"Annuler","cancelled":"Annul\u00e9","cancelled_appointment":"Rendez-vous annul\u00e9 !","category":"Cat\u00e9gorie","check_in":"Enregistrement","check_out":"Check-out","city":"Ville","contact_number":"Le num\u00e9ro de contact est","country":"Pays","currency":"Devise","custom":"Plage personnalis\u00e9e","day":"Jour","dec":"D\u00e9c","degree_required":"Le champ degr\u00e9 est obligatoire.","delete":"Supprimer","deleted":"Supprim\u00e9\u00a0!","description_no_white_space":"Le champ de la description courte ne doit pas contenir uniquement des espaces blancs","discard":"Jeter","doctor":"Docteur","doctor_required":"Le champ du docteur est obligatoire.","doctor_session":"Programme du docteur","dose_interval":"S\u00e9lectionner l'intervalle de dose","email_already_exist":"L'e-mail est d\u00e9j\u00e0 abonn\u00e9.","email_required":"Le champ de l'e-mail est obligatoire.","enquiry":"Enqu\u00eate","enter_lot_number":"Entrez le num\u00e9ro de lot.","enter_sale_price":"Entrez le prix de vente.","error":"Erreur","experience_required":"Le champ de l'exp\u00e9rience est obligatoire.","faqs":"FAQ","feb":"F\u00e9v","first_name_required":"Le champ du pr\u00e9nom est obligatoire.","fri":"VEN","from":"De","front_medical_services":"Services m\u00e9dicaux frontaux","front_patient_testimonials":"T\u00e9moignages de patients frontaux","has_been":"a \u00e9t\u00e9 supprim\u00e9.","has_cancel":" a \u00e9t\u00e9 annul\u00e9.","image_file_type":"L'image doit \u00eatre un fichier de type : jpeg, jpg, png.","invalid_country_code":"Code pays invalide","invalid_number":"Num\u00e9ro invalide","jan":"Jan","jul":"Juil","jun":"Juin","last_30_days":"30 derniers jours","last_month":"Le mois dernier","last_name_required":"Le champ du nom de famille est obligatoire.","last_week":"La semaine derni\u00e8re","live_consultations":"Consultations en direct","mar":"Mar","may":"Mai","medicine":"M\u00e9dicament","medicine_bill":"Facture de m\u00e9dicaments","mon":"LUN","month":"Mois","net_amount_not_empty":"Le montant net ne peut pas \u00eatre vide.","net_amount_not_zero":"Le montant net ne peut pas \u00eatre z\u00e9ro.","no":"Non, Annuler","note_white_space":"Le champ de note ne doit pas contenir uniquement des espaces blancs.","notification_read":"Notification lue avec succ\u00e8s.","nov":"Nov","observation_white_space":"Le champ d'observation ne doit pas contenir uniquement des espaces blancs.","oct":"Oct","ok":"Ok","patient":"Patient","patient_smart_card_deleted":"Carte de patient","payment_type_required":"Le champ de la m\u00e9thode de paiement est obligatoire.","please_select_patient":"Veuillez s\u00e9lectionner un patient","please_wait":"Veuillez patienter...","prescription":"Ordonnance","privacy_policy":"Politique de confidentialit\u00e9","privacy_policy_required.":"La politique de confidentialit\u00e9 est obligatoire.","problem_white_space":"Le champ probl\u00e8me ne doit pas contenir uniquement des espaces blancs.","processing":"Traitement...","purchase_medicine":"Acheter des m\u00e9dicaments","qualification":"Qualification","quantity_should":"La quantit\u00e9 doit \u00eatre sup\u00e9rieure \u00e0 0.","roles":"R\u00f4les","sat":"SAM","save":"Enregistrer","select_calendar.":"Veuillez s\u00e9lectionner un calendrier.","select_category":"S\u00e9lectionner une cat\u00e9gorie","select_city":"S\u00e9lectionner une ville","select_doctor":"S\u00e9lectionner un docteur","select_duration":"S\u00e9lectionner la dur\u00e9e","select_medicine":"S\u00e9lectionner un m\u00e9dicament","select_patient":"S\u00e9lectionnez le patient","select_payment":"Veuillez s\u00e9lectionner une m\u00e9thode de paiement","select_service":"S\u00e9lectionner un service","select_state":"S\u00e9lectionner un \u00e9tat","sep":"Sep","service":"Service","service_category":"Cat\u00e9gorie de service","service_required":"Le champ des services est obligatoire.","specializations":"Sp\u00e9cialisations","staff":"Personnel","state":"\u00c9tat","status_update":"Statut mis \u00e0 jour avec succ\u00e8s.","subscriber_creat":"Abonn\u00e9 cr\u00e9\u00e9 avec succ\u00e8s.","subscribers":"Abonn\u00e9s","sun":"DIM","tax_cannot_be_zero_empty":"Le montant de la taxe ne peut pas \u00eatre z\u00e9ro ou vide.","tax_should_be":"Les imp\u00f4ts devraient \u00eatre inf\u00e9rieurs \u00e0 100%.","terms_conditions":"Conditions g\u00e9n\u00e9rales","the_discount_shoul":"La remise doit \u00eatre inf\u00e9rieure au montant total","the_medicine_already_in_use":"Ce m\u00e9dicament est d\u00e9j\u00e0 utilis\u00e9 dans des factures de m\u00e9dicaments. \u00cates-vous s\u00fbr de vouloir le supprimer?","this_month":"Ce mois-ci","this_week":"Cette semaine","thu":"JEU","title_no_white_space":"Le champ du titre ne doit pas contenir uniquement des espaces blancs","to":"\u00c0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","unavailable":"Indisponible","university_required":"L'universit\u00e9 est obligatoire.","update_quantity":"La quantit\u00e9 mise \u00e0 jour doit \u00eatre inf\u00e9rieure \u00e0 la quantit\u00e9 pr\u00e9c\u00e9dente.","valid_instagram":"Veuillez entrer une URL Instagram valide","valid_linkedin":"Veuillez entrer une URL Linkedin valide","valid_twitter":"Veuillez entrer une URL Twitter valide","visits":"Visites","wed":"MER","year_required":"L'ann\u00e9e est obligatoire.","yes":"Oui, Supprimer !","yes_update":"Oui, Mettre \u00e0 jour !","yesterday":"Hier"},"it.js":{"Terms_Conditions_required":"I Termini e Condizioni sono obbligatori","all_notification_read":"Tutte le notifiche lette con successo.","amount":"Importo","apply":"Applica","appointment":"Appuntamento","appointment_date_required":"Il campo della data dell'appuntamento \u00e8 obbligatorio.","apr":"Apr","are_you_sure":"Sei sicuro di voler eliminare questo","are_you_sure_cancel":"Sei sicuro di voler annullare questo","aug":"Ago","booked":"Prenotato","brand":"Marca","cancel":"Annulla","cancelled":"Annullato","cancelled_appointment":"Appuntamento Annullato!","category":"Categoria","check_in":"Check-in","check_out":"Check-out","city":"Citt\u00e0","contact_number":"Il numero di contatto \u00e8","country":"Paese","currency":"Valuta","custom":"Intervallo Personalizzato","day":"Giorno","dec":"Dic","degree_required":"Il campo del grado \u00e8 obbligatorio.","delete":"Elimina","deleted":"Eliminato!","description_no_white_space":"Il campo Descrizione Breve non deve contenere solo spazi vuoti","discard":"Scarta","doctor":"Dottore","doctor_required":"Il campo del dottore \u00e8 obbligatorio.","doctor_session":"Orario del Dottore","dose_interval":"Seleziona Intervallo di Dose","email_already_exist":"L'email \u00e8 gi\u00e0 registrata.","email_required":"Il campo dell'email \u00e8 obbligatorio.","enquiry":"Richiesta","enter_lot_number":"Inserisci il numero di lotto.","enter_sale_price":"Inserisci il prezzo di vendita.","error":"Errore","experience_required":"Il campo Esperienza \u00e8 obbligatorio.","faqs":"Domande frequenti","feb":"Feb","first_name_required":"Il campo del nome \u00e8 obbligatorio.","fri":"VEN","from":"Da","front_medical_services":"Servizi Medici Frontali","front_patient_testimonials":"Testimonianze dei Pazienti Frontali","has_been":"\u00e8 stato eliminato.","has_cancel":" \u00e8 stato annullato.","image_file_type":"L'immagine deve essere un file di tipo: jpeg, jpg, png.","invalid_country_code":"Codice Paese non valido","invalid_number":"Numero non valido","jan":"Gen","jul":"Lug","jun":"Giu","last_30_days":"Ultimi 30 Giorni","last_month":"Mese Scorso","last_name_required":"Il campo del cognome \u00e8 obbligatorio.","last_week":"Settimana Scorsa","live_consultations":"Consulenze Live","mar":"Mar","may":"Mag","medicine":"Medicina","medicine_bill":"Fattura Farmaceutica","mon":"LUN","month":"Mese","net_amount_not_empty":"L'importo netto non pu\u00f2 essere vuoto.","net_amount_not_zero":"L'importo netto non pu\u00f2 essere zero.","no":"No, Annulla","note_white_space":"Il campo Nota non deve contenere solo spazi bianchi.","notification_read":"Notifica letta con successo.","nov":"Nov","observation_white_space":"Il campo Osservazione non deve contenere solo spazi bianchi.","oct":"Ott","ok":"Ok","patient":"Paziente","patient_smart_card_deleted":"Carta Smart del Paziente","payment_type_required":"Il campo del Metodo di Pagamento \u00e8 obbligatorio.","please_select_patient":"Seleziona Paziente","please_wait":"Attendere prego...","prescription":"Prescrizione","privacy_policy":"Informativa sulla Privacy","privacy_policy_required.":"L'Informativa sulla Privacy \u00e8 obbligatoria.","problem_white_space":"Il campo Problema non deve contenere solo spazi bianchi.","processing":"Elaborazione in corso...","purchase_medicine":"Acquista Medicina","qualification":"Qualifica","quantity_should":"La quantit\u00e0 dovrebbe essere maggiore di 0.","roles":"Ruoli","sat":"SAB","save":"Salva","select_calendar.":"Seleziona un calendario.","select_category":"Seleziona Categoria","select_city":"Seleziona Citt\u00e0","select_doctor":"Seleziona Dottore","select_duration":"Seleziona Durata","select_medicine":"Seleziona Medicina","select_patient":"Seleziona Paziente","select_payment":"Seleziona un Metodo di Pagamento","select_service":"Seleziona Servizio","select_state":"Seleziona Stato","sep":"Set","service":"Servizio","service_category":"Categoria di Servizio","service_required":"Il campo dei servizi \u00e8 obbligatorio.","specializations":"Specializzazioni","staff":"Personale","state":"Stato","status_update":"Stato aggiornato con successo.","subscriber_creat":"Abbonato creato con successo.","subscribers":"Abbonati","sun":"DOM","tax_cannot_be_zero_empty":"L'importo delle tasse non pu\u00f2 essere zero o vuoto.","tax_should_be":"Le tasse dovrebbero essere inferiori al 100%.","terms_conditions":"Termini e Condizioni","the_discount_shoul":"Lo sconto deve essere inferiore all'importo totale","the_medicine_already_in_use":"Questa medicina \u00e8 gi\u00e0 utilizzata nelle fatture farmaceutiche, sei sicuro di volerla eliminare?","this_month":"Questo Mese","this_week":"Questa Settimana","thu":"GIO","title_no_white_space":"Il campo Titolo non deve contenere solo spazi vuoti","to":"A","today":"Oggi","too_long":"Troppo lungo","too_short":"Troppo corto","tue":"MAR","unavailable":"Non disponibile","university_required":"L'universit\u00e0 \u00e8 obbligatoria.","update_quantity":"La quantit\u00e0 di aggiornamento deve essere inferiore alla quantit\u00e0 precedente.","valid_instagram":"Inserisci un URL Instagram valido","valid_linkedin":"Inserisci un URL Linkedin valido","valid_twitter":"Inserisci un URL Twitter valido","visits":"Visite","wed":"MER","year_required":"L'anno \u00e8 obbligatorio.","yes":"S\u00ec, Elimina!","yes_update":"S\u00ec, Aggiorna!","yesterday":"Ieri"},"pt.js":{"Terms_Conditions_required":"Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios","all_notification_read":"Todas as notifica\u00e7\u00f5es foram lidas com sucesso.","amount":"Valor","apply":"Aplicar","appointment":"Consulta","appointment_date_required":"O campo de data da consulta \u00e9 obrigat\u00f3rio.","apr":"Abr","are_you_sure":"Tem certeza de que deseja excluir isso","are_you_sure_cancel":"Tem certeza de que deseja cancelar isso","aug":"Ago","booked":"Agendado","brand":"Marca","cancel":"Cancelar","cancelled":"Cancelado","cancelled_appointment":"Consulta Cancelada!","category":"Categoria","check_in":"Check-in","check_out":"Check-out","city":"Cidade","contact_number":"O n\u00famero de contato \u00e9","country":"Pa\u00eds","currency":"Moeda","custom":"Intervalo Personalizado","day":"Dia","dec":"Dez","degree_required":"O campo de forma\u00e7\u00e3o \u00e9 obrigat\u00f3rio.","delete":"Excluir","deleted":"Exclu\u00eddo!","description_no_white_space":"O campo de descri\u00e7\u00e3o curta n\u00e3o deve conter apenas espa\u00e7os em branco","discard":"Descartar","doctor":"M\u00e9dico","doctor_required":"O campo de m\u00e9dico \u00e9 obrigat\u00f3rio.","doctor_session":"Agenda do M\u00e9dico","dose_interval":"Intervalo de Dose","email_already_exist":"O e-mail j\u00e1 est\u00e1 inscrito.","email_required":"O campo de e-mail \u00e9 obrigat\u00f3rio.","enquiry":"Consulta","enter_lot_number":"Inserir n\u00famero do lote.","enter_sale_price":"Inserir pre\u00e7o de venda.","error":"Erro","experience_required":"O campo de experi\u00eancia \u00e9 obrigat\u00f3rio.","faqs":"Perguntas Frequentes","feb":"Fev","first_name_required":"O campo de nome \u00e9 obrigat\u00f3rio.","fri":"SEX","from":"De","front_medical_services":"Servi\u00e7os M\u00e9dicos Frontais","front_patient_testimonials":"Depoimentos de Pacientes Frontais","has_been":"foi exclu\u00eddo.","has_cancel":" foi cancelado.","image_file_type":"A imagem deve ser do tipo: jpeg, jpg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","jan":"Jan","jul":"Jul","jun":"Jun","last_30_days":"\u00daltimos 30 Dias","last_month":"M\u00eas Passado","last_name_required":"O campo de sobrenome \u00e9 obrigat\u00f3rio.","last_week":"Semana Passada","live_consultations":"Consultas ao Vivo","mar":"Mar","may":"Mai","medicine":"Medicamento","medicine_bill":"Fatura de Medicamentos","mon":"SEG","month":"M\u00eas","net_amount_not_empty":"O valor l\u00edquido n\u00e3o pode estar vazio.","net_amount_not_zero":"O valor l\u00edquido n\u00e3o pode ser zero.","no":"N\u00e3o, Cancelar","note_white_space":"O campo Nota n\u00e3o deve conter apenas espa\u00e7os em branco.","notification_read":"Notifica\u00e7\u00e3o lida com sucesso.","nov":"Nov","observation_white_space":"O campo Observa\u00e7\u00e3o n\u00e3o deve conter apenas espa\u00e7os em branco.","oct":"Out","ok":"Ok","patient":"Paciente","patient_smart_card_deleted":"Cart\u00e3o Inteligente do Paciente","payment_type_required":"O campo de m\u00e9todo de pagamento \u00e9 obrigat\u00f3rio.","please_select_patient":"Por favor, selecione um paciente","please_wait":"Por favor, aguarde...","prescription":"Receita M\u00e9dica","privacy_policy":"Pol\u00edtica de Privacidade","privacy_policy_required.":"A Pol\u00edtica de Privacidade \u00e9 obrigat\u00f3ria.","problem_white_space":"O campo Problema n\u00e3o deve conter apenas espa\u00e7os em branco.","processing":"Processando...","purchase_medicine":"Comprar Medicamento","qualification":"Qualifica\u00e7\u00e3o","quantity_should":"A quantidade deve ser maior que 0.","roles":"Fun\u00e7\u00f5es","sat":"S\u00c1B","save":"Salvar","select_calendar.":"Por favor, selecione um calend\u00e1rio.","select_category":"Selecionar Categoria","select_city":"Selecionar Cidade","select_doctor":"Selecionar M\u00e9dico","select_duration":"Selecionar Dura\u00e7\u00e3o","select_medicine":"Selecionar Medicamento","select_patient":"Selecionar Paciente","select_payment":"Por favor, selecione um m\u00e9todo de pagamento","select_service":"Selecionar Servi\u00e7o","select_state":"Selecionar Estado","sep":"Set","service":"Servi\u00e7o","service_category":"Categoria de Servi\u00e7o","service_required":"O campo de servi\u00e7os \u00e9 obrigat\u00f3rio.","specializations":"Especializa\u00e7\u00f5es","staff":"Equipe","state":"Estado","status_update":"Status atualizado com sucesso.","subscriber_creat":"Inscrito criado com sucesso.","subscribers":"Inscritos","sun":"DOM","tax_cannot_be_zero_empty":"O valor do imposto n\u00e3o pode ser zero ou vazio.","tax_should_be":"Os impostos devem ser inferiores a 100%.","terms_conditions":"Termos e Condi\u00e7\u00f5es","the_discount_shoul":"O desconto deve ser menor que o valor total","the_medicine_already_in_use":"Este medicamento j\u00e1 est\u00e1 sendo usado em faturas de medicamentos. Tem certeza de que deseja exclu\u00ed-lo?","this_month":"Este M\u00eas","this_week":"Esta Semana","thu":"QUI","title_no_white_space":"O campo de t\u00edtulo n\u00e3o deve conter apenas espa\u00e7os em branco","to":"Para","today":"Hoje","too_long":"Muito longo","too_short":"Muito curto","tue":"TER","unavailable":"Indispon\u00edvel","university_required":"A universidade \u00e9 obrigat\u00f3ria.","update_quantity":"A quantidade de atualiza\u00e7\u00e3o deve ser menor que a quantidade anterior.","valid_instagram":"Por favor, insira um URL do Instagram v\u00e1lido","valid_linkedin":"Por favor, insira um URL do Linkedin v\u00e1lido","valid_twitter":"Por favor, insira um URL do Twitter v\u00e1lido","visits":"Visitas","wed":"QUA","year_required":"O ano \u00e9 obrigat\u00f3rio.","yes":"Sim, Excluir!","yes_update":"Sim, Atualizar!","yesterday":"Ontem"},"ru.js":{"Terms_Conditions_required":"\u0422\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","all_notification_read":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b.","amount":"\u0421\u0443\u043c\u043c\u0430","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c","appointment":"\u0417\u0430\u043f\u0438\u0441\u044c \u043d\u0430 \u043f\u0440\u0438\u0435\u043c","appointment_date_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0438\u0441\u0438.","apr":"\u0410\u043f\u0440","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e","are_you_sure_cancel":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e","aug":"\u0410\u0432\u0433","booked":"\u0417\u0430\u043f\u0438\u0441\u0430\u043d\u043e","brand":"\u0411\u0440\u0435\u043d\u0434","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","cancelled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","cancelled_appointment":"\u0417\u0430\u043f\u0438\u0441\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430!","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","check_in":"\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f","check_out":"\u0412\u044b\u043f\u0438\u0441\u043a\u0430","city":"\u0413\u043e\u0440\u043e\u0434","contact_number":"\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","country":"\u0421\u0442\u0440\u0430\u043d\u0430","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","custom":"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d","day":"\u0414\u0435\u043d\u044c","dec":"\u0414\u0435\u043a","degree_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441\u0442\u0435\u043f\u0435\u043d\u0438.","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e!","description_no_white_space":"\u041f\u043e\u043b\u0435 \u043a\u0440\u0430\u0442\u043a\u043e\u0433\u043e \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b","discard":"\u041e\u0442\u0431\u0440\u043e\u0441\u0438\u0442\u044c","doctor":"\u0414\u043e\u043a\u0442\u043e\u0440","doctor_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0432\u0440\u0430\u0447\u0430.","doctor_session":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0430","dose_interval":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0434\u043e\u0437\u0438\u0440\u043e\u0432\u043a\u0438","email_already_exist":"\u042d\u0442\u043e\u0442 \u0430\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b \u0443\u0436\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d.","email_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b.","enquiry":"\u0417\u0430\u043f\u0440\u043e\u0441","enter_lot_number":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043f\u0430\u0440\u0442\u0438\u0438.","enter_sale_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0438.","error":"\u041e\u0448\u0438\u0431\u043a\u0430","experience_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u043f\u043e\u043b\u0435 \u043e\u043f\u044b\u0442\u0430.","faqs":"\u0427\u0430\u0441\u0442\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b","feb":"\u0424\u0435\u0432","first_name_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0438\u043c\u0435\u043d\u0438.","fri":"\u041f\u0422","from":"\u041e\u0442","front_medical_services":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438","front_patient_testimonials":"\u041e\u0442\u0437\u044b\u0432\u044b \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","has_been":"\u0431\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.","has_cancel":" \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.","image_file_type":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpeg, jpg, png.","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","jan":"\u042f\u043d\u0432","jul":"\u0418\u044e\u043b","jun":"\u0418\u044e\u043d","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_month":"\u0412 \u043f\u0440\u043e\u0448\u043b\u043e\u043c \u043c\u0435\u0441\u044f\u0446\u0435","last_name_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0444\u0430\u043c\u0438\u043b\u0438\u0438.","last_week":"\u041d\u0430 \u043f\u0440\u043e\u0448\u043b\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","live_consultations":"\u041e\u043d\u043b\u0430\u0439\u043d-\u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u0438","mar":"\u041c\u0430\u0440","may":"\u041c\u0430\u0439","medicine":"\u041b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","medicine_bill":"\u0421\u0447\u0435\u0442 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","mon":"\u041f\u041d","month":"\u041c\u0435\u0441\u044f\u0446","net_amount_not_empty":"\u0421\u0443\u043c\u043c\u0430 \u043a \u0432\u044b\u0447\u0435\u0442\u0443 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439.","net_amount_not_zero":"\u0421\u0443\u043c\u043c\u0430 \u043a \u0432\u044b\u0447\u0435\u0442\u0443 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439.","no":"\u041d\u0435\u0442, \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","note_white_space":"\u041f\u043e\u043b\u0435 \u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b.","notification_read":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e.","nov":"\u041d\u043e\u044f","observation_white_space":"\u041f\u043e\u043b\u0435 \u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b.","oct":"\u041e\u043a\u0442","ok":"\u041e\u043a","patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442","patient_smart_card_deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043a\u0430\u0440\u0442\u0430 \u0443\u043c\u043d\u043e\u0433\u043e \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","payment_type_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u043c\u0435\u0442\u043e\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b.","please_select_patient":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","please_wait":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435...","prescription":"\u0420\u0435\u0446\u0435\u043f\u0442","privacy_policy":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","privacy_policy_required.":"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438.","problem_white_space":"\u041f\u043e\u043b\u0435 \u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b.","processing":"\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430..","purchase_medicine":"\u041f\u043e\u043a\u0443\u043f\u043a\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432","qualification":"\u041a\u0432\u0430\u043b\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f","quantity_should":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 0.","roles":"\u0420\u043e\u043b\u0438","sat":"\u0421\u0411","save":"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c","select_calendar.":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c.","select_category":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e","select_city":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u043e\u0440\u043e\u0434","select_doctor":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0442\u043e\u0440\u0430","select_duration":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","select_medicine":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0443","select_patient":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","select_payment":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u0437 \u043c\u0435\u0442\u043e\u0434\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b","select_service":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443","select_state":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0442\u0430\u0442","sep":"\u0421\u0435\u043d","service":"\u0423\u0441\u043b\u0443\u0433\u0430","service_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0443\u0441\u043b\u0443\u0433","service_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u0443\u0441\u043b\u0443\u0433.","specializations":"\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438","staff":"\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b","state":"\u0428\u0442\u0430\u0442","status_update":"\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d.","subscriber_creat":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d.","subscribers":"\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438","sun":"\u0412\u0421","tax_cannot_be_zero_empty":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u043d\u0430 \u043d\u0443\u043b\u044e \u0438\u043b\u0438 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439.","tax_should_be":"\u041d\u0430\u043b\u043e\u0433\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u0435\u0435 100%.","terms_conditions":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","the_discount_shoul":"\u0421\u043a\u0438\u0434\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043e\u0431\u0449\u0435\u0439 \u0441\u0443\u043c\u043c\u044b","the_medicine_already_in_use":"\u042d\u0442\u043e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0441\u0447\u0435\u0442\u0430\u0445 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430, \u0432\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c?","this_month":"\u0412 \u044d\u0442\u043e\u043c \u043c\u0435\u0441\u044f\u0446\u0435","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","title_no_white_space":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u044b","to":"\u0414\u043e","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u044b\u0439","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","tue":"\u0412\u0422","unavailable":"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e","university_required":"\u0423\u043d\u0438\u0432\u0435\u0440\u0441\u0438\u0442\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d.","update_quantity":"\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430.","valid_instagram":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL Instagram","valid_linkedin":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL Linkedin","valid_twitter":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL Twitter","visits":"\u041f\u043e\u0441\u0435\u0449\u0435\u043d\u0438\u044f","wed":"\u0421\u0420","year_required":"\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d \u0433\u043e\u0434.","yes":"\u0414\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","yes_update":"\u0414\u0430, \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c!","yesterday":"\u0412\u0447\u0435\u0440\u0430"},"tr.js":{"Terms_Conditions_required":"Kullan\u0131m \u015eartlar\u0131 zorunludur","all_notification_read":"T\u00fcm bildirimler ba\u015far\u0131yla okundu.","amount":"Miktar","apply":"Uygula","appointment":"Randevu","appointment_date_required":"Randevu tarihi alan\u0131 zorunludur.","apr":"Nis","are_you_sure":"Bunu silmek istedi\u011finizden emin misiniz","are_you_sure_cancel":"Bunu iptal etmek istedi\u011finizden emin misiniz ","aug":"A\u011fu","booked":"Rezerve Edildi","brand":"Marka","cancel":"\u0130ptal","cancelled":"\u0130ptal Edildi","cancelled_appointment":"Randevu \u0130ptal Edildi!","category":"Kategori","check_in":"Giri\u015f","check_out":"\u00c7\u0131k\u0131\u015f","city":"\u015eehir","contact_number":"\u0130leti\u015fim numaras\u0131","country":"\u00dclke","currency":"Para Birimi","custom":"\u00d6zel Aral\u0131k","day":"G\u00fcn","dec":"Ara","degree_required":"Derece alan\u0131 zorunludur.","delete":"Sil","deleted":"Silindi!","description_no_white_space":"K\u0131sa A\u00e7\u0131klama alan\u0131 sadece bo\u015fluk i\u00e7ermemelidir","discard":"At","doctor":"Doktor","doctor_required":"Doktor alan\u0131 zorunludur.","doctor_session":"Doktor Program\u0131","dose_interval":"Doz Aral\u0131\u011f\u0131 Se\u00e7","email_already_exist":"E-posta zaten abone olmu\u015f.","email_required":"E-posta alan\u0131 zorunludur.","enquiry":"Soru\u015fturma","enter_lot_number":"Lot numaras\u0131n\u0131 girin.","enter_sale_price":"Sat\u0131\u015f fiyat\u0131n\u0131 girin.","error":"Hata","experience_required":"Deneyim alan\u0131 zorunludur.","faqs":"SSS","feb":"\u015eub","first_name_required":"Ad alan\u0131 zorunludur.","fri":"CUM","from":"Ba\u015flang\u0131\u00e7","front_medical_services":"\u00d6n T\u0131bbi Hizmetler","front_patient_testimonials":"\u00d6n Hasta G\u00f6r\u00fc\u015fleri","has_been":"silindi.","has_cancel":" iptal edildi.","image_file_type":"Resim jpeg, jpg, png t\u00fcr\u00fcnde bir dosya olmal\u0131d\u0131r.","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz Numara","jan":"Oca","jul":"Tem","jun":"Haz","last_30_days":"Son 30 G\u00fcn","last_month":"Ge\u00e7en Ay","last_name_required":"Soyad\u0131 alan\u0131 zorunludur.","last_week":"Ge\u00e7en Hafta","live_consultations":"Canl\u0131 Dan\u0131\u015fmalar","mar":"Mar","may":"May","medicine":"\u0130la\u00e7","medicine_bill":"\u0130la\u00e7 Faturas\u0131","mon":"PTS","month":"Ay","net_amount_not_empty":"Net tutar bo\u015f olamaz.","net_amount_not_zero":"Net tutar s\u0131f\u0131r olamaz.","no":"Hay\u0131r, \u0130ptal Et","note_white_space":"Not alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7eremez.","notification_read":"Bildirim ba\u015far\u0131yla okundu.","nov":"Kas","observation_white_space":"G\u00f6zlem alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7eremez.","oct":"Eki","ok":"Tamam","patient":"Hasta","patient_smart_card_deleted":"Hasta Ak\u0131ll\u0131 Kart","payment_type_required":"\u00d6deme Y\u00f6ntemi alan\u0131 zorunludur.","please_select_patient":"L\u00fctfen hasta se\u00e7in","please_wait":"L\u00fctfen bekleyin...","prescription":"Re\u00e7ete","privacy_policy":"Gizlilik Politikas\u0131","privacy_policy_required.":"Gizlilik Politikas\u0131 zorunludur.","problem_white_space":"Sorun alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7eremez.","processing":"\u0130\u015fleniyor..","purchase_medicine":"\u0130la\u00e7 Sat\u0131n Alma","qualification":"Nitellik","quantity_should":"Miktar 0'dan b\u00fcy\u00fck olmal\u0131d\u0131r.","roles":"Roller","sat":"CMT","save":"Kaydet","select_calendar.":"L\u00fctfen bir takvim se\u00e7in.","select_category":"Kategori Se\u00e7","select_city":"\u015eehir Se\u00e7","select_doctor":"Doktor Se\u00e7","select_duration":"S\u00fcre Se\u00e7","select_medicine":"\u0130la\u00e7 Se\u00e7","select_patient":"Hasta Se\u00e7","select_payment":"L\u00fctfen bir \u00f6deme y\u00f6ntemi se\u00e7in","select_service":"Hizmet Se\u00e7","select_state":"Eyalet Se\u00e7","sep":"Eyl","service":"Hizmet","service_category":"Hizmet Kategorisi","service_required":"Hizmet alan\u0131 zorunludur.","specializations":"Uzmanl\u0131k Alanlar\u0131","staff":"Personel","state":"Eyalet","status_update":"Durum ba\u015far\u0131yla g\u00fcncellendi.","subscriber_creat":"Abone ba\u015far\u0131yla olu\u015fturuldu.","subscribers":"Aboneler","sun":"PAZ","tax_cannot_be_zero_empty":"Vergi miktar\u0131 s\u0131f\u0131r veya bo\u015f olamaz.","tax_should_be":"Vergiler, %100'den az olmal\u0131d\u0131r.","terms_conditions":"Kullan\u0131m \u015eartlar\u0131","the_discount_shoul":"\u0130ndirim toplam tutardan d\u00fc\u015f\u00fck olmal\u0131d\u0131r","the_medicine_already_in_use":"Bu ila\u00e7 zaten ila\u00e7 faturalar\u0131nda kullan\u0131l\u0131yor, silmek istedi\u011finizden emin misiniz?","this_month":"Bu Ay","this_week":"Bu Hafta","thu":"PER","title_no_white_space":"Ba\u015fl\u0131k alan\u0131 sadece bo\u015fluk i\u00e7ermemelidir","to":"Biti\u015f","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SAL","unavailable":"Uygun de\u011fil","university_required":"\u00dcniversite zorunludur.","update_quantity":"G\u00fcncelleme miktar\u0131 \u00f6nceki miktar\u0131n alt\u0131nda olmal\u0131d\u0131r.","valid_instagram":"L\u00fctfen ge\u00e7erli bir Instagram URL'si girin","valid_linkedin":"L\u00fctfen ge\u00e7erli bir Linkedin URL'si girin","valid_twitter":"L\u00fctfen ge\u00e7erli bir Twitter URL'si girin","visits":"Ziyaretler","wed":"\u00c7AR","year_required":"Y\u0131l zorunludur.","yes":"Evet, Sil!","yes_update":"Evet, G\u00fcncelle!","yesterday":"D\u00fcn"},"zh.js":{"Terms_Conditions_required":"\u9700\u8981\u6761\u6b3e\u548c\u6761\u4ef6","all_notification_read":"\u6240\u6709\u901a\u77e5\u5df2\u6210\u529f\u9605\u8bfb\u3002","amount":"\u91d1\u989d","apply":"\u5e94\u7528","appointment":"\u9884\u7ea6","appointment_date_required":"\u9884\u7ea6\u65e5\u671f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","apr":"\u56db\u6708","are_you_sure":"\u60a8\u786e\u5b9a\u8981\u5220\u9664\u6b64","are_you_sure_cancel":"\u60a8\u786e\u5b9a\u8981\u53d6\u6d88\u6b64","aug":"\u516b\u6708","booked":"\u5df2\u9884\u8ba2","brand":"\u54c1\u724c","cancel":"\u53d6\u6d88","cancelled":"\u5df2\u53d6\u6d88","cancelled_appointment":"\u5df2\u53d6\u6d88\u9884\u7ea6\uff01","category":"\u7c7b\u522b","check_in":"\u7b7e\u5230","check_out":"\u7b7e\u51fa","city":"\u57ce\u5e02","contact_number":"\u8054\u7cfb\u7535\u8bdd\u4e3a","country":"\u56fd\u5bb6","currency":"\u8d27\u5e01","custom":"\u81ea\u5b9a\u4e49\u8303\u56f4","day":"\u5929","dec":"\u5341\u4e8c\u6708","degree_required":"\u9700\u8981\u5b66\u4f4d\u5b57\u6bb5\u3002","delete":"\u5220\u9664","deleted":"\u5df2\u522a\u9664\uff01","description_no_white_space":"\u5173\u4e8e\u77ed\u63cf\u8ff0\u5b57\u6bb5\u4e0d\u80fd\u53ea\u5305\u542b\u7a7a\u683c","discard":"\u4e22\u5f03","doctor":"\u533b\u751f","doctor_required":"\u533b\u751f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","doctor_session":"\u533b\u751f\u65e5\u7a0b","dose_interval":"\u9009\u62e9\u5242\u91cf\u95f4\u9694","email_already_exist":"\u8be5\u7535\u5b50\u90ae\u4ef6\u5df2\u7ecf\u8ba2\u9605\u3002","email_required":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","enquiry":"\u67e5\u8be2","enter_lot_number":"\u8f93\u5165\u6279\u53f7\u3002","enter_sale_price":"\u8f93\u5165\u9500\u552e\u4ef7\u683c\u3002","error":"\u9519\u8bef","experience_required":"\u5173\u4e8e\u7ecf\u9a8c\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","faqs":"\u5e38\u89c1\u95ee\u9898","feb":"\u4e8c\u6708","first_name_required":"\u540d\u5b57\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","fri":"\u661f\u671f\u4e94","from":"\u4ece","front_medical_services":"\u524d\u7aef\u533b\u7597\u670d\u52a1","front_patient_testimonials":"\u524d\u7aef\u60a3\u8005\u89c1\u8bc1","has_been":"\u5df2\u5220\u9664\u3002","has_cancel":"\u5df2\u53d6\u6d88\u3002","image_file_type":"\u56fe\u50cf\u5fc5\u987b\u662fjpeg\uff0cjpg\uff0cpng\u7c7b\u578b\u7684\u6587\u4ef6\u3002","invalid_country_code":"\u65e0\u6548\u7684\u56fd\u5bb6\u4ee3\u7801","invalid_number":"\u65e0\u6548\u7684\u53f7\u7801","jan":"\u4e00\u6708","jul":"\u4e03\u6708","jun":"\u516d\u6708","last_30_days":"\u8fc7\u53bb30\u5929","last_month":"\u4e0a\u6708","last_name_required":"\u59d3\u6c0f\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","last_week":"\u4e0a\u5468","live_consultations":"\u5728\u7ebf\u54a8\u8be2","mar":"\u4e09\u6708","may":"\u4e94\u6708","medicine":"\u836f\u54c1","medicine_bill":"\u836f\u54c1\u8d26\u5355","mon":"\u661f\u671f\u4e00","month":"\u6708","net_amount_not_empty":"\u51c0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002","net_amount_not_zero":"\u51c0\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6\u3002","no":"\u4e0d\uff0c\u53d6\u6d88","note_white_space":"\u5907\u6ce8\u5b57\u6bb5\u4e0d\u4ec5\u5305\u542b\u7a7a\u683c\u3002","notification_read":"\u901a\u77e5\u5df2\u6210\u529f\u9605\u8bfb\u3002","nov":"\u5341\u4e00\u6708","observation_white_space":"\u89c2\u5bdf\u5b57\u6bb5\u4e0d\u4ec5\u5305\u542b\u7a7a\u683c\u3002","oct":"\u5341\u6708","ok":"\u597d\u7684","patient":"\u60a3\u8005","patient_smart_card_deleted":"\u60a3\u8005\u667a\u80fd\u5361\u5df2\u5220\u9664","payment_type_required":"\u9700\u8981\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u6bb5\u3002","please_select_patient":"\u8bf7\u9009\u62e9\u60a3\u8005","please_wait":"\u8bf7\u7a0d\u5019...","prescription":"\u5904\u65b9","privacy_policy":"\u9690\u79c1\u653f\u7b56","privacy_policy_required.":"\u9700\u8981\u9690\u79c1\u653f\u7b56\u3002","problem_white_space":"\u95ee\u9898\u5b57\u6bb5\u4e0d\u4ec5\u5305\u542b\u7a7a\u683c\u3002","processing":"\u5904\u7406\u4e2d...","purchase_medicine":"\u8d2d\u4e70\u836f\u54c1","qualification":"\u8d44\u683c","quantity_should":"\u6570\u91cf\u5e94\u5927\u4e8e0\u3002","roles":"\u89d2\u8272","sat":"\u661f\u671f\u516d","save":"\u4fdd\u5b58","select_calendar.":"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65e5\u5386\u3002","select_category":"\u9009\u62e9\u7c7b\u522b","select_city":"\u9009\u62e9\u57ce\u5e02","select_doctor":"\u9009\u62e9\u533b\u751f","select_duration":"\u9009\u62e9\u65f6\u957f","select_medicine":"\u9009\u62e9\u836f\u7269","select_patient":"\u9009\u62e9\u60a3\u8005","select_payment":"\u8bf7\u9009\u62e9\u4efb\u4e00\u4ed8\u6b3e\u65b9\u5f0f","select_service":"\u9009\u62e9\u670d\u52a1","select_state":"\u9009\u62e9\u5dde","sep":"\u4e5d\u6708","service":"\u670d\u52a1","service_category":"\u670d\u52a1\u7c7b\u522b","service_required":"\u670d\u52a1\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","specializations":"\u4e13\u4e1a\u9886\u57df","staff":"\u5458\u5de5","state":"\u5dde","status_update":"\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","subscriber_creat":"\u8ba2\u9605\u8005\u521b\u5efa\u6210\u529f\u3002","subscribers":"\u8ba2\u9605\u8005","sun":"\u661f\u671f\u5929","tax_cannot_be_zero_empty":"\u7a0e\u989d\u4e0d\u80fd\u4e3a\u96f6\u6216\u4e3a\u7a7a\u3002","tax_should_be":"\u7a0e\u6536\u5e94\u4f4e\u4e8e100%\u3002","terms_conditions":"\u6761\u6b3e\u548c\u6761\u4ef6","the_discount_shoul":"\u6298\u6263\u5e94\u5c0f\u4e8e\u603b\u91d1\u989d","the_medicine_already_in_use":"\u6b64\u836f\u54c1\u5df2\u5728\u836f\u54c1\u8d26\u5355\u4e2d\u4f7f\u7528\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f","this_month":"\u672c\u6708","this_week":"\u672c\u5468","thu":"\u661f\u671f\u56db","title_no_white_space":"\u5173\u4e8e\u6807\u9898\u5b57\u6bb5\u4e0d\u80fd\u53ea\u5305\u542b\u7a7a\u683c","to":"\u81f3","today":"\u4eca\u5929","too_long":"\u592a\u957f","too_short":"\u592a\u77ed","tue":"\u661f\u671f\u4e8c","unavailable":"\u4e0d\u53ef\u7528","university_required":"\u9700\u8981\u5927\u5b66\u3002","update_quantity":"\u66f4\u65b0\u6570\u91cf\u5e94\u5c0f\u4e8e\u5148\u524d\u6570\u91cf\u3002","valid_instagram":"\u8bf7\u8f93\u5165\u6709\u6548\u7684Instagram\u7f51\u5740","valid_linkedin":"\u8bf7\u8f93\u5165\u6709\u6548\u7684LinkedIn\u7f51\u5740","valid_twitter":"\u8bf7\u8f93\u5165\u6709\u6548\u7684Twitter\u7f51\u5740","visits":"\u8bbf\u95ee","wed":"\u661f\u671f\u4e09","year_required":"\u9700\u8981\u5e74\u4efd\u3002","yes":"\u662f\u7684\uff0c\u5220\u9664\uff01","yes_update":"\u662f\u7684\uff0c\u66f4\u65b0\uff01","yesterday":"\u6628\u5929"}});
})();
